'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Form_Close()
    On Error Resume Next
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    'aktuelles Whrungsformat des Systems einstellen
    Me.Text8.Format = "Currency"
End Sub

Private Sub Stornierungsgrund_AfterUpdate()
    Me.Stornierungsgrund.Value = Left(Trim(Me.Stornierungsgrund.Value), 100)
End Sub

Private Sub Stornierungsgrund_Change()
    'Prfung der Textbreite in den Start-Button verlegt,
    'um ein Flimmern wrend der Eingabe zu verhindern.
End Sub

Private Sub Storno_START_Click()
On Error GoTo Err_Storno_START_Click
    Dim Kuerzung As Boolean
    Dim dbs As Database
    Dim Text As String
    
    'Prfen, ob ein Stornierungsgrund angegeben wurde
    If IsNull(Me.Stornierungsgrund.Value) Or (Me.Stornierungsgrund.Value = "") Then
        MsgBox "Bitte geben Sie einen Grund fr die Stornierung der Rechnung ein.", vbInformation + vbOKOnly, "Hinweis"
        Me.Stornierungsgrund.SetFocus
        Exit Sub
    End If
    
    'Prfung der Textbreite
    Kuerzung = False
    'Belegung der Variablen
    Me.Stornierungsgrund.SetFocus                                       'Auswertung des Inhalts nur mglich, wenn Element den Fokus hat
    If Len(Me.Stornierungsgrund.Text) > 100 Then Kuerzung = True        'Meldung aktivieren
    TextEingabe = Left(LTrim(Me.Stornierungsgrund.Text), 100)
    TextBreite = 0
    'Ermittlung der TextBreite
    MaxTextBreite = 4250    'maximale Textbreite in Twips festlegen; Stornotext = 4250 Twips
    DoCmd.OpenReport "BlankoBericht", acViewPreview
    DoCmd.Close acReport, "BlankoBericht", acSaveNo
    'Beschrnkung des Eingabetextes auf die maximale Lnge
    If MaxTextLaenge > 0 Then
        TextEingabe = Left(TextEingabe, MaxTextLaenge)
        Kuerzung = True
    End If
    Me.Stornierungsgrund.SetFocus
    Me.Stornierungsgrund.Value = TextEingabe
    Me.Stornierungsgrund.SelStart = 250         'Kursor ans Ende des Textes stellen
    If Kuerzung = True Then
        MsgBox "Der Stornierungsgrund wurde auf die darstellbare Lnge gekrzt. Bitte prfen Sie den Text und krzen ihn gegebenenfalls sinnvoll ab.", vbInformation + vbOKOnly, "Hinweis"
        Me.Stornierungsgrund.SetFocus
        Me.Stornierungsgrund.SelStart = 250         'Kursor ans Ende des Textes stellen
        Exit Sub
    End If
    
    If MsgBox("Wollen Sie die Rechnung wirklich stornieren?", vbYesNo + vbDefaultButton2 + vbExclamation, "Rechnung stornieren...") = vbNo Then Exit Sub
    
    'Formularnamen merken fr Aktualisierung,
    'falls Stornomarkierung gendert (gesetzt) wird
    FormularName = "Rechnungen_Uebersicht"
    ReNrIntern = Me.Re_interneNummer
    StornoTerminNegativsaldo = False
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    FilterRechnungen = "SELECT * FROM Rechnungen WHERE ([lfd_Nr]=" & ReNrIntern & ")"
    Set rstRechnungen = dbs.OpenRecordset(FilterRechnungen)
    
    'Markierung und Datum setzen
    rstRechnungen.Edit
    rstRechnungen!Re_Storno = True
    rstRechnungen!Re_Storno_Datum = Now()
    rstRechnungen!Re_Storno_Art = Me.Storno_Optionen.Value
    rstRechnungen!Re_Storno_Grund = Me.Stornierungsgrund.Value
    'rstRechnungen!Re_Storno_lfd_Nr = ...         'zur Zeit ungenutzt
    rstRechnungen!Re_Storno_Netto = rstRechnungen!Re_Netto * (-1)
    rstRechnungen!Re_Storno_MwSt = rstRechnungen!Re_MwSt * (-1)
    rstRechnungen!Re_Storno_Brutto = rstRechnungen!Re_Brutto * (-1)
    rstRechnungen.Update
    rstRechnungen.Bookmark = rstRechnungen.LastModified
    
    'merken
    ReNummer = rstRechnungen!Re_Nr
    ReGesamtNetto = rstRechnungen!Re_Brutto         ' Ok!, da nur zur Anzeige benutzt.
    ReStornoOption = Me.Storno_Optionen
        
    'sich selbst schlieen
    DoCmd.Close acForm, "Rechnung_stornieren", acSaveYes
    
    'Rechnungspositionen abarbeiten
    RechnungPositionenStorno
    
    'Tabelle "Rechnungen" schlieen
    rstRechnungen.Close
    'Datenbankbereich freigeben
    Set dbs = Nothing
        
    'Ansicht des Formular "Rechnungsbuch" erneuern, um Storno anzuzeigen
    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
    DoCmd.OpenForm "Rechnungen_Uebersicht", , , , , , ReNrIntern
    
    'Hinweis ausgeben
    If StornoTerminNegativsaldo = False Then
        MsgBox "Die Rechnung wurde storniert.", vbOKOnly + vbInformation, "Hinweis"
    Else
        Text = "Die Rechnung wurde storniert."
        Text = Text & vbNewLine & vbNewLine & "ACHTUNG: Es gibt mindestens einen Termin " & _
            "mit einem negativem Saldo (Guthaben!). Bitte prfen Sie anhand von Termin- und " & _
            "Rechnungsliste, ob doppelte Terminstornierungen vorliegen."
        MsgBox Text, vbOKOnly + vbExclamation, "Hinweis"
    End If


Exit_Storno_START_Click:
    Exit Sub

Err_Storno_START_Click:
    MsgBox err.Description
    Resume Exit_Storno_START_Click

End Sub
